#include <bits/stdc++.h>
using namespace std;

int main() {
    int N;
    long long W;
    double eps;
    cin >> N >> W >> eps;
    vector<long long> w(N), v(N);
    long long V = 0;
    for (int i = 0; i < N; i++) {
        cin >> w[i] >> v[i];
        V = max(V, v[i]);
    }
    if (V == 0) {
        cout << 0 << endl;
        return 0;
    }
    double delta = eps * V / N;
    vector<long long> v_scaled(N);
    for (int i = 0; i < N; i++) {
        v_scaled[i] = floor(v[i] / delta);
    }
    // DP
    vector<vector<long long>> dp(N + 1, vector<long long>(W + 1, LLONG_MIN));
    vector<vector<int>> prev(N + 1, vector<int>(W + 1, -1));
    dp[0][0] = 0;
    for (int i = 0; i < N; i++) {
        for (long long j = 0; j <= W; j++) {
            if (dp[i][j] != LLONG_MIN) {
         
                if (dp[i + 1][j] < dp[i][j]) {
                    dp[i + 1][j] = dp[i][j];
                    prev[i + 1][j] = -1;
                }
       
                if (j + w[i] <= W) {
                    long long newval = dp[i][j] + v_scaled[i];
                    if (dp[i + 1][j + w[i]] < newval) {
                        dp[i + 1][j + w[i]] = newval;
                        prev[i + 1][j + w[i]] = i;
                    }
                }
            }
        }
    }

    long long max_scaled = LLONG_MIN;
    long long best_j = -1;
    for (long long j = 0; j <= W; j++) {
        if (dp[N][j] > max_scaled) {
            max_scaled = dp[N][j];
            best_j = j;
        }
    }
  
    vector<int> selected;
    int curr_i = N;
    long long curr_j = best_j;
    while (curr_i > 0) {
        int item = prev[curr_i][curr_j];
        if (item != -1) {
            selected.push_back(item);
            curr_j -= w[item];
        }
        curr_i--;
    }
    reverse(selected.begin(), selected.end());
    cout << selected.size() << endl;
    for (int idx : selected) {
        cout << (idx + 1) << " ";
    }
    cout << endl;
    return 0;
}